/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;

public class ArmorPurgatoryModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> PURGA = TConstruct.createKey((String)"purgatory_armor");

    public ArmorPurgatoryModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorPurgatoryModifier::onHurt);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(PURGA, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(PURGA, (Object)0);
            if (level > 0 && attacker != null && living instanceof Player) {
                Player player = (Player)living;
                if (attacker.m_5825_()) {
                    event.setAmount(event.getAmount() * 0.7f);
                }
            }
        });
    }
}

